/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.tools.modifiers.upgrades.general.ReinforcedModifier;

public class OxideLayerModifier
extends Modifier {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "oxide_mod");
    private static final Component UNBREAKING = TConstruct.makeTranslation((String)"modifier", (String)"oxide.unbreaking");

    public int getPriority() {
        return 125;
    }

    public int onDamageTool(IToolStackView tool, int level, int amount, @javax.annotation.Nullable LivingEntity holder) {
        ModDataNBT persistantData = tool.getPersistentData();
        if (persistantData.contains(this.KEY, 5)) {
            float value = persistantData.getFloat(this.KEY);
            if ((double)value >= 1.5 * (double)level) {
                return ReinforcedModifier.damageReinforced((int)amount, (float)((float)(0.15 * (double)level)));
            }
            return ReinforcedModifier.damageReinforced((int)amount, (float)(value / 10.0f));
        }
        return amount;
    }

    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(this.KEY);
    }

    public void onInventoryTick(@Nonnull IToolStackView tool, int level, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT persistantData = tool.getPersistentData();
        if (!world.f_46443_ && holder.f_19797_ % (300 / level) == 0 && holder.m_21211_() != stack && isSelected && (double)persistantData.getFloat(this.KEY) <= 1.5 * (double)level && RANDOM.nextFloat() <= 0.6f * (float)level) {
            persistantData.putFloat(this.KEY, persistantData.getFloat(this.KEY) + 0.1f);
        }
    }

    public void addInformation(@Nonnull IToolStackView tool, int level, @Nullable Player player, @Nonnull List<Component> tooltip, @Nonnull TooltipKey tooltipKey, @Nonnull TooltipFlag tooltipFlag) {
        ModDataNBT persistantData;
        if (player != null && (persistantData = tool.getPersistentData()).contains(this.KEY, 5)) {
            float value = persistantData.getFloat(this.KEY);
            if ((double)value >= 1.5 * (double)level) {
                this.addPercentTooltip(UNBREAKING, 0.15 * (double)level, tooltip);
            } else if ((double)value < 1.5 * (double)level) {
                this.addPercentTooltip(UNBREAKING, value / 10.0f, tooltip);
            }
        }
    }
}

